﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SimplePlane : MonoBehaviour {
    public float target_kmph_ = 100f;
    
    // Update is called once per frame
    void Update () {
	var hori = Input.GetAxis("Horizontal");
	var vert = Input.GetAxis("Vertical");
	var rb = GetComponent<Rigidbody>();
	rb.AddRelativeTorque(0f, hori, -hori);
	rb.AddRelativeTorque(vert, 0f, 0f);

	var left = transform.TransformVector(Vector3.left);
	var horizontal_left = new Vector3(left.x, 0f, left.z).normalized;
	rb.AddTorque(Vector3.Cross(left, horizontal_left) * 2);

	var forward = transform.TransformVector(Vector3.forward);
	var horizontal_forward = new Vector3(forward.x, 0f, forward.z).normalized;
	rb.AddTorque(Vector3.Cross(forward, horizontal_forward) * 2);
	
	var force = (rb.mass*rb.drag*target_kmph_/3.6f)/(1f - rb.drag*Time.fixedDeltaTime);
	Debug.Log(force);
	rb.AddRelativeForce(new Vector3(0f, 0f, force));
	
    }
}
