﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SimplePlayer : MonoBehaviour { 	
    Rigidbody rb_;

    void Start(){
	//リジッドボディコンポーネントをrb_に取得
	rb_ = GetComponent<Rigidbody>();
    }

    /* シンプルに動かしてみよう
    void Update () {
	// 水平・垂直入力を取得してPositionに加算する
	var vert = Input.GetAxis("Vertical");
	var hori = Input.GetAxis("Horizontal");
	transform.position += new Vector3(hori, vert, 0f);
    */

    /* Rigidbodyを使おう */ 
    // コンポーネントでRigidbodyを追加・UseGravityはオフにしておく
    // キー入力後もCubeが慣性で動くならばDragをかけて下さい
    // 同じコンポーネントを２つ付けるとkmph + kmph の結果になります
    void FixedUpdate() {
	// 水平・垂直入力を取得してリジッドボディに力を与える
	var vert = Input.GetAxis("Vertical");
	var hori = Input.GetAxis("Horizontal");
	
	var kmph = 100f;
	var mps = kmph * (1000f / 3600f);
	var target_velocity = mps * hori;
	var v = new Vector3(target_velocity, vert * 20f, 0f);

	//var force = new Vector3(hori * 60f, vert * 60f, 0f);
	
	// 終端速度を得るのにdragに値を入れてください
	var force = (rb_.mass * rb_.drag * v) / (1f - rb_.drag * Time.fixedDeltaTime);
	rb_.AddForce(force);
	Debug.LogFormat("velocity={0}km/h", rb_.velocity.magnitude * (3600f / 1000f));
    }

    
}
